/**
  ******************************************************************************
  * @file    main.c
  * @author  Puya Application Team
  * @version V1.0
  * @brief   Main program body
  ******************************************************************************
  * @attention
  *
  * <h2><center>&copy; Copyright (c) 2023 Puya Semiconductor.
  * All rights reserved.</center></h2>
  *
  ******************************************************************************
  */

/* Includes ------------------------------------------------------------------*/
#include "main.h"
#include "bootloader.h"

#if (0x1FFF0000 == VECT_TAB_BASE)
const char BuildInfo[0x40] __attribute__((section(".ARM.__at_0x1FFF0800"))) = "PT103 Bootloader Build: " __DATE__ " " __TIME__ " " ;
#endif

/** @defgroup RCC_HSI_Calibration HSI Calibration
* @{
*/
#define RCC_HSICALIBRATION_8MHz        ((0x0<<26) | (((*(uint32_t *)(0x1FFF1200)) & 0x7FF) << 4))  /*!< 8MHz HSI calibration trimming value */
#define RCC_HSICALIBRATION_16MHz       ((0x1<<26) | (((*(uint32_t *)(0x1FFF1204)) & 0x7FF) << 4))  /*!< 16MHz HSI calibration trimming value */
#define RCC_HSICALIBRATION_24MHz       ((0x2<<26) | (((*(uint32_t *)(0x1FFF1208)) & 0x7FF) << 4))  /*!< 24MHz HSI calibration trimming value */
#define RCC_HSICALIBRATION_48MHz       ((0x3<<26) | (((*(uint32_t *)(0x1FFF120C)) & 0x7FF) << 4))  /*!< 24MHz HSI calibration trimming value */

/**
  * @brief  The application entry point.
  * @param  None
  * @retval None
  */
int main(void)
{
  /* Set the HSI clock to 24MHz by default */
  MODIFY_REG(RCC->CR, (RCC_CR_HSIFS | RCC_CR_HSITRIM), (uint32_t)(RCC_HSICALIBRATION_24MHz));
  
  Bootloader_Init();

  /* Infinite loop */
  while (1)
  {
    Bootloader_ProtocolDetection();
  }
}

#ifdef  USE_FULL_ASSERT
/**
  * @brief  Reports the name of the source file and the source line number
  *         where the assert_param error has occurred.
  * @param  file: pointer to the source file name
  * @param  line: assert_param error line source number
  * @retval None
  */
void assert_failed(uint8_t* file, uint32_t line)
{
  /* User can add his own implementation to report the file name and line number,
     ex: printf("Wrong parameters value: file %s on line %d\r\n", file, line) */

  /* Infinite loop */
  while (1)
  {
    printf("Wrong parameters value: file %s on line %d\r\n", file, line);
  }
}
#endif
/**
  * @}
  */


/************************ (C) COPYRIGHT Puya Semiconductor *****END OF FILE****/
